--Create expanded "VariTech" TABLE based on the Support tables that begin with "expBldg"
DROP TABLE IF EXISTS support."expVariTech";
CREATE TABLE support."expVariTech"
 AS (
(SELECT "LookupID",
        "BldgType",
        "VintageYear" as "BldgVint",
        "HvacType" as "BldgHVAC",
        "expBldgLoc"."BldgLoc",
        "TechID"
FROM support."VariTech"
JOIN support."expBldgLoc" on "expBldgLoc"."CZ" = "VariTech"."CZ"
WHERE "VariTech"."BldgType" <> 'Any'
  and "VariTech"."VintageYear" <> 'Any'
  and "VariTech"."HvacType" <> 'Any'
)
UNION
(SELECT "LookupID",
        "VariTech"."BldgType",
        "expBldgVint"."BldgVint",
        "expBldgHVAC"."BldgHVAC",
        "expBldgLoc"."BldgLoc",
        "TechID"
FROM support."VariTech"
JOIN support."expBldg2VintHVAC" on "expBldg2VintHVAC"."BldgType" = "VariTech"."BldgType"
JOIN support."expBldgVint" on "expBldgVint"."VintType" = "expBldg2VintHVAC"."VintType"
JOIN support."expBldgHVAC" on "expBldgHVAC"."HVACType" = "expBldg2VintHVAC"."HVACType"
JOIN support."expBldgLoc" on "expBldgLoc"."CZ" = "VariTech"."CZ"
WHERE "VariTech"."BldgType" <> 'Any'
  and "VariTech"."VintageYear" = 'Any'
  and "VariTech"."HvacType" = 'Any'
)
UNION
(SELECT "LookupID",
        "VariTech"."BldgType",
        "VintageYear" as "BldgVint",
        "expBldgHVAC"."BldgHVAC",
        "expBldgLoc"."BldgLoc",
        "TechID"
FROM support."VariTech"
JOIN support."expBldg2VintHVAC" on "expBldg2VintHVAC"."BldgType" = "VariTech"."BldgType"
JOIN support."expBldgHVAC" on "expBldgHVAC"."HVACType" = "expBldg2VintHVAC"."HVACType"
JOIN support."expBldgLoc" on "expBldgLoc"."CZ" = "VariTech"."CZ"
WHERE "VariTech"."BldgType" <> 'Any'
  and "VariTech"."VintageYear" <> 'Any'
  and "VariTech"."HvacType" = 'Any'
)
UNION
(SELECT "LookupID",
        "VariTech"."BldgType",
        "expBldgVint"."BldgVint",
        "HvacType" as "BldgHVAC",
        "expBldgLoc"."BldgLoc",
        "TechID"
FROM support."VariTech"
JOIN support."expBldg2VintHVAC" on "expBldg2VintHVAC"."BldgType" = "VariTech"."BldgType"
JOIN support."expBldgVint" on "expBldgVint"."VintType" = "expBldg2VintHVAC"."VintType"
JOIN support."expBldgLoc" on "expBldgLoc"."CZ" = "VariTech"."CZ"
WHERE "VariTech"."BldgType" <> 'Any'
  and "VariTech"."VintageYear" = 'Any'
  and "VariTech"."HvacType" <> 'Any'
)

UNION
(SELECT "LookupID",
        "expBldgType"."BldgType",
        "expBldgVint"."BldgVint",
        "expBldgHVAC"."BldgHVAC",
        "expBldgLoc"."BldgLoc",
        "TechID"
FROM support."VariTech"
JOIN support."expBldgType" on "VariTech"."Sector"= "expBldgType"."Sector"
JOIN support."expBldg2VintHVAC" on "expBldg2VintHVAC"."BldgType" = "expBldgType"."BldgType"
JOIN support."expBldgVint" on "expBldgVint"."VintType" = "expBldg2VintHVAC"."VintType"
JOIN support."expBldgHVAC" on "expBldgHVAC"."HVACType" = "expBldg2VintHVAC"."HVACType"
JOIN support."expBldgLoc" on "expBldgLoc"."CZ" = "VariTech"."CZ"
WHERE "VariTech"."BldgType" = 'Any'
  and "VariTech"."VintageYear" = 'Any'
  and "VariTech"."HvacType" = 'Any'
)
UNION
(SELECT "LookupID",
        "expBldgType"."BldgType",
        "VintageYear" as "BldgVint",
        "expBldgHVAC"."BldgHVAC",
        "expBldgLoc"."BldgLoc",
        "TechID"
FROM support."VariTech"
JOIN support."expBldgType" on "VariTech"."Sector"= "expBldgType"."Sector"
JOIN support."expBldg2VintHVAC" on "expBldg2VintHVAC"."BldgType" = "expBldgType"."BldgType"
JOIN support."expBldgHVAC" on "expBldgHVAC"."HVACType" = "expBldg2VintHVAC"."HVACType"
JOIN support."expBldgLoc" on "expBldgLoc"."CZ" = "VariTech"."CZ"
WHERE "VariTech"."BldgType" = 'Any'
  and "VariTech"."VintageYear" <> 'Any'
  and "VariTech"."HvacType" = 'Any'
)
UNION
(SELECT "LookupID",
        "expBldgType"."BldgType",
        "expBldgVint"."BldgVint",
        "HvacType" as "BldgHVAC",
        "expBldgLoc"."BldgLoc",
        "TechID"
FROM support."VariTech"
JOIN support."expBldgType" on "VariTech"."Sector"= "expBldgType"."Sector"
JOIN support."expBldg2VintHVAC" on "expBldg2VintHVAC"."BldgType" = "expBldgType"."BldgType"
JOIN support."expBldgVint" on "expBldgVint"."VintType" = "expBldg2VintHVAC"."VintType"
JOIN support."expBldgLoc" on "expBldgLoc"."CZ" = "VariTech"."CZ"
WHERE "VariTech"."BldgType" = 'Any'
  and "VariTech"."VintageYear" = 'Any'
  and "VariTech"."HvacType" <> 'Any'
)
UNION
(SELECT "LookupID",
        "expBldgType"."BldgType",
        "VintageYear" as "BldgVint",
        "HvacType" as "BldgHVAC",
        "expBldgLoc"."BldgLoc",
        "TechID"
FROM support."VariTech"
JOIN support."expBldgType" on "VariTech"."Sector"= "expBldgType"."Sector"
JOIN support."expBldgLoc" on "expBldgLoc"."CZ" = "VariTech"."CZ"
WHERE "VariTech"."BldgType" = 'Any'
  and "VariTech"."VintageYear" <> 'Any'
  and "VariTech"."HvacType" <> 'Any'
)
)